/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.solaris.rad.transports;

import com.oracle.solaris.rad.transports.UnixDomainSocket;
import com.oracle.solaris.rad.transports.UnixInputStream;
import com.oracle.solaris.rad.transports.UnixOutputStream;
import com.oracle.solaris.rad.transports.UnixSocketClosedException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class UnixSocket
implements Closeable {
    private boolean closed_ = false;
    private boolean closeme_ = false;
    private int fd_;
    private InputStream input_;
    private OutputStream output_;
    private ReadWriteLock rwlock_;

    private native int socket_read(int var1) throws IOException;

    private native int socket_read(int var1, byte[] var2, int var3, int var4) throws IOException;

    private native long socket_skip(int var1, long var2) throws IOException;

    private native void socket_flush(int var1) throws IOException;

    private native void socket_write(int var1, int var2) throws IOException;

    private native void socket_write(int var1, byte[] var2, int var3, int var4) throws IOException;

    private native String socket_peeruser(int var1) throws IOException;

    private native byte[] socket_peeraudit(int var1) throws IOException;

    UnixSocket(int n) {
        this.fd_ = n;
        this.rwlock_ = new ReentrantReadWriteLock();
    }

    protected void finalize() throws Throwable {
        if (!this.closed_) {
            this.closed_ = true;
            UnixDomainSocket.socket_close(this.fd_);
        }
    }

    public synchronized InputStream getInputStream() {
        if (this.input_ == null) {
            this.input_ = new UnixInputStream(this);
        }
        return this.input_;
    }

    public synchronized OutputStream getOutputStream() {
        if (this.output_ == null) {
            this.output_ = new UnixOutputStream(this);
        }
        return this.output_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        UnixSocket unixSocket = this;
        synchronized (unixSocket) {
            if (this.closed_ || this.closeme_) {
                return;
            }
            UnixDomainSocket.socket_goose(this.fd_);
            this.closeme_ = true;
        }
        this.rwlock_.writeLock().lock();
        try {
            if (!this.closed_) {
                UnixDomainSocket.socket_close(this.fd_);
                this.closed_ = true;
            }
        }
        finally {
            this.rwlock_.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isClosing() {
        UnixSocket unixSocket = this;
        synchronized (unixSocket) {
            return this.closeme_;
        }
    }

    public String getPeerUser() throws IOException {
        this.rwlock_.readLock().lock();
        try {
            if (this.closed_) {
                throw new UnixSocketClosedException("read peer of");
            }
            String string = this.socket_peeruser(this.fd_);
            if (this.isClosing()) {
                throw new UnixSocketClosedException("read peer of");
            }
            String string2 = string;
            return string2;
        }
        finally {
            this.rwlock_.readLock().unlock();
        }
    }

    public byte[] getPeerAuditContext() throws IOException {
        this.rwlock_.readLock().lock();
        try {
            if (this.closed_) {
                throw new UnixSocketClosedException("read peer of");
            }
            byte[] byArray = this.socket_peeraudit(this.fd_);
            if (this.isClosing()) {
                throw new UnixSocketClosedException("read peer of");
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            this.rwlock_.readLock().unlock();
        }
    }

    int read() throws IOException {
        this.rwlock_.readLock().lock();
        try {
            if (this.closed_) {
                throw new UnixSocketClosedException("read from");
            }
            int n = this.socket_read(this.fd_);
            if (n < 0 && this.isClosing()) {
                throw new UnixSocketClosedException("read from");
            }
            int n2 = n;
            return n2;
        }
        finally {
            this.rwlock_.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int read(byte[] byArray, int n, int n2) throws IOException {
        this.rwlock_.readLock().lock();
        try {
            if (this.closed_) {
                throw new UnixSocketClosedException("read from");
            }
            int n3 = this.socket_read(this.fd_, byArray, n, n2);
            if (n3 < 0 && this.isClosing()) {
                throw new UnixSocketClosedException("read from");
            }
            int n4 = n3;
            return n4;
        }
        finally {
            this.rwlock_.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long skip(long l) throws IOException {
        this.rwlock_.readLock().lock();
        try {
            if (this.closed_) {
                throw new UnixSocketClosedException("read from");
            }
            long l2 = this.socket_skip(this.fd_, l);
            if (l2 < l && this.isClosing()) {
                throw new UnixSocketClosedException("read from");
            }
            long l3 = l2;
            return l3;
        }
        finally {
            this.rwlock_.readLock().unlock();
        }
    }

    void flush() throws IOException {
        this.rwlock_.readLock().lock();
        try {
            if (this.closed_) {
                throw new UnixSocketClosedException("flush");
            }
            this.socket_flush(this.fd_);
            if (this.isClosing()) {
                throw new UnixSocketClosedException("flush");
            }
        }
        finally {
            this.rwlock_.readLock().unlock();
        }
    }

    void write(int n) throws IOException {
        this.rwlock_.readLock().lock();
        try {
            if (this.closed_) {
                throw new UnixSocketClosedException("write to");
            }
            this.socket_write(this.fd_, n);
            if (this.isClosing()) {
                throw new UnixSocketClosedException("write to");
            }
        }
        finally {
            this.rwlock_.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(byte[] byArray, int n, int n2) throws IOException {
        this.rwlock_.readLock().lock();
        try {
            if (this.closed_) {
                throw new UnixSocketClosedException("write to");
            }
            this.socket_write(this.fd_, byArray, n, n2);
            if (this.isClosing()) {
                throw new UnixSocketClosedException("write to");
            }
        }
        finally {
            this.rwlock_.readLock().unlock();
        }
    }
}

