/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.solaris.rad.transports;

import com.oracle.solaris.rad.transports.RadTrustManager;
import com.oracle.solaris.rad.transports.Transport;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SocketTransport
implements Transport {
    private Socket socket_;

    public SocketTransport(Socket socket) {
        this.socket_ = socket;
    }

    public static SocketTransport newSocketTransport(InetAddress inetAddress, int n) throws IOException {
        return new SocketTransport(new Socket(inetAddress, n));
    }

    public static SocketTransport newSSLSocketTransport(InetAddress inetAddress, int n, String string, KeyStore keyStore, RadTrustManager radTrustManager) throws IOException {
        Object object;
        String[] stringArray;
        Object object2;
        SSLSocketFactory sSLSocketFactory = null;
        try {
            object2 = SSLContext.getInstance("TLS");
            stringArray = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            stringArray.init(keyStore);
            object = stringArray.getTrustManagers();
            if (radTrustManager != null) {
                radTrustManager.wrap((X509TrustManager)object[0]);
                object = new TrustManager[]{radTrustManager};
            }
            ((SSLContext)object2).init(null, (TrustManager[])object, null);
            sSLSocketFactory = ((SSLContext)object2).getSocketFactory();
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
        object2 = (SSLSocket)sSLSocketFactory.createSocket(new Socket(inetAddress, n), string, n, true);
        stringArray = ((SSLSocket)object2).getSupportedProtocols();
        object = new ArrayList();
        for (String string2 : stringArray) {
            if (!string2.contains("TLSv1.") || string2.contains("TLSv1.0")) continue;
            ((ArrayList)object).add(string2);
        }
        ((SSLSocket)object2).setEnabledProtocols(((ArrayList)object).toArray(new String[((ArrayList)object).size()]));
        return new SocketTransport((Socket)object2);
    }

    private static Certificate getCertificate(String string) throws FileNotFoundException, CertificateException, IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        Certificate certificate = CertificateFactory.getInstance("X.509").generateCertificate(fileInputStream);
        fileInputStream.close();
        return certificate;
    }

    public static SocketTransport newSSLSocketTransport(String string, int n, Set<String> set) throws IOException {
        KeyStore keyStore;
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(string);
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            for (String string2 : set) {
                Certificate certificate = SocketTransport.getCertificate(string2);
                String string3 = ((X509Certificate)certificate).getIssuerDN().toString();
                KeyStore.TrustedCertificateEntry trustedCertificateEntry = new KeyStore.TrustedCertificateEntry(certificate);
                keyStore.setEntry(string3, trustedCertificateEntry, null);
            }
        }
        catch (KeyStoreException keyStoreException) {
            throw new IOException(keyStoreException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException(noSuchAlgorithmException);
        }
        catch (CertificateException certificateException) {
            throw new IOException(certificateException);
        }
        return SocketTransport.newSSLSocketTransport(inetAddress, n, string, keyStore, null);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.socket_.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.socket_.getOutputStream();
    }

    @Override
    public void close() throws IOException {
        this.socket_.close();
    }
}

