/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.solaris.rad.transports;

import com.oracle.solaris.rad.transports.PipeTransport;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class PrivateTransport
extends PipeTransport {
    private static final String RAD_PATH = "/usr/lib/rad/rad";
    private static final String RAD_MOD_XPORT = "/usr/lib/rad/transport/mod_pipe.so";
    private static final String RAD_MOD_PROTO = "/usr/lib/rad/protocol/mod_proto_rad.so";
    private static final String[] RAD_MODULE_DIRS = new String[]{"/usr/lib/rad/module", "/usr/lib/rad/site-modules"};
    private String root;
    private List<String> modules;
    private List<String> auxargs;

    public PrivateTransport(String string, List<String> list, List<String> list2) throws IOException {
        this.auxargs = list2;
        this.modules = list;
        this.root = string;
    }

    @Override
    protected List<String> getCommand() throws IOException {
        String string;
        if (this.root != null) {
            if (!this.root.startsWith("/")) {
                throw new IOException("root directory must be absolute");
            }
            string = this.root + RAD_PATH;
        } else {
            string = RAD_PATH;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(string);
        PrivateTransport.addModule(linkedList, this.root, RAD_MOD_XPORT);
        PrivateTransport.addModule(linkedList, this.root, RAD_MOD_PROTO);
        if (this.modules.isEmpty()) {
            for (String string2 : RAD_MODULE_DIRS) {
                PrivateTransport.addModuleDir(linkedList, this.root, string2);
            }
        } else {
            for (String string3 : this.modules) {
                PrivateTransport.addModule(linkedList, this.root, string3);
            }
        }
        linkedList.addAll(this.auxargs);
        linkedList.add("-t");
        linkedList.add("stdin:exit");
        return linkedList;
    }

    private static void addModule(List<String> list, String string, String string2) {
        list.add("-M");
        list.add(PrivateTransport.mapPath(string, string2));
    }

    private static void addModuleDir(List<String> list, String string, String string2) {
        list.add("-m");
        list.add(PrivateTransport.mapPath(string, string2));
    }

    private static String mapPath(String string, String string2) {
        return string == null || !string2.startsWith("/") ? string2 : string + string2;
    }
}

