/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.solaris.rad.transports;

import com.oracle.solaris.rad.transports.Transport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public abstract class PipeTransport
implements Transport {
    private Process process;

    @Override
    public void close() throws IOException {
        this.getProcess().destroy();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.getProcess().getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.getProcess().getOutputStream();
    }

    protected Process createProcess() throws IOException {
        return Runtime.getRuntime().exec(this.getCommand().toArray(new String[0]));
    }

    protected abstract List<String> getCommand() throws IOException;

    private synchronized Process getProcess() throws IOException {
        if (this.process == null) {
            this.process = this.createProcess();
        }
        return this.process;
    }
}

