/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.solaris.rad.encodings.xdr;

import com.oracle.solaris.rad.encodings.xdr.XDROutput;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public class XDROutputStream
implements XDROutput {
    private static final byte[] zeroes = new byte[]{0, 0, 0};
    private ByteBuffer buffer_ = ByteBuffer.allocate(16);
    private OutputStream stream_;

    private void write(int n) throws IOException {
        assert (this.buffer_.remaining() >= n);
        this.stream_.write(this.buffer_.array(), 0, n);
    }

    public XDROutputStream(OutputStream outputStream) {
        this.stream_ = outputStream;
    }

    @Override
    public XDROutputStream putInteger(int n) throws IOException {
        this.buffer_.clear();
        this.buffer_.putInt(n);
        this.write(4);
        return this;
    }

    @Override
    public XDROutputStream putUInteger(long l) throws IOException {
        if (l < 0L) {
            throw new IOException("signed value passed to putUInteger()");
        }
        if (l > 0xFFFFFFFFL) {
            throw new IOException("out-of-range value passed to putUInteger()");
        }
        this.buffer_.clear();
        this.buffer_.putInt((int)l);
        this.write(4);
        return this;
    }

    @Override
    public XDROutputStream putBoolean(boolean bl) throws IOException {
        this.buffer_.clear();
        this.buffer_.putInt(bl ? 1 : 0);
        this.write(4);
        return this;
    }

    @Override
    public XDROutputStream putHyper(long l) throws IOException {
        this.buffer_.clear();
        this.buffer_.putLong(l);
        this.write(8);
        return this;
    }

    @Override
    public XDROutputStream putUHyper(BigInteger bigInteger) throws IOException {
        if (bigInteger.signum() < 0) {
            throw new IOException("signed value passed to putUHyper()");
        }
        if (bigInteger.bitLength() > 64) {
            throw new IOException("out-of-range value passed to putUHyper()");
        }
        this.buffer_.clear();
        this.buffer_.putLong(bigInteger.longValue());
        this.write(8);
        return this;
    }

    @Override
    public XDROutputStream putFloat(float f) throws IOException {
        this.buffer_.clear();
        this.buffer_.putFloat(f);
        this.write(4);
        return this;
    }

    @Override
    public XDROutputStream putDouble(double d) throws IOException {
        this.buffer_.clear();
        this.buffer_.putDouble(d);
        this.write(8);
        return this;
    }

    private void bump(int n) throws IOException {
        int n2 = n % 4;
        if (n2 != 0) {
            this.stream_.write(zeroes, 0, 4 - n2);
        }
    }

    @Override
    public XDROutputStream putFixedOpaque(byte[] byArray, int n, int n2) throws IOException {
        this.stream_.write(byArray, n, n2);
        this.bump(n2);
        return this;
    }

    @Override
    public XDROutputStream putOpaque(byte[] byArray, int n, int n2) throws IOException {
        this.putInteger(n2);
        return this.putFixedOpaque(byArray, n, n2);
    }

    public XDROutputStream putOpaque(byte[] byArray) throws IOException {
        return this.putOpaque(byArray, 0, byArray.length);
    }

    public XDROutputStream putOpaque(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        int n = byteArrayOutputStream.size();
        this.putInteger(n);
        byteArrayOutputStream.writeTo(this.stream_);
        this.bump(n);
        return this;
    }

    @Override
    public XDROutputStream putString(String string) throws IOException {
        byte[] byArray = string.getBytes();
        return this.putOpaque(byArray, 0, byArray.length);
    }
}

