/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.solaris.rad.encodings.xdr;

import com.oracle.solaris.rad.encodings.xdr.XDRInput;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public class XDRInputStream
implements XDRInput {
    private InputStream stream_;
    private ByteBuffer buffer_ = ByteBuffer.allocate(256);

    private void read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n + n2;
        while (n < n3) {
            int n4 = this.stream_.read(byArray, n, n3 - n);
            if (n4 == -1) {
                throw new IOException("read failed: end of file reached");
            }
            n += n4;
        }
    }

    private void bump(int n) throws IOException {
        int n2 = n % 4;
        if (n2 != 0) {
            this.stream_.skip(4 - n2);
        }
    }

    private boolean getBytes(int n) throws IOException {
        this.read(this.buffer_.array(), 0, n);
        this.buffer_.limit(n);
        this.buffer_.rewind();
        return true;
    }

    public XDRInputStream(InputStream inputStream) {
        this.stream_ = inputStream;
    }

    public XDRInputStream(byte[] byArray) {
        this.stream_ = new ByteArrayInputStream(byArray);
    }

    @Override
    public int getInteger() throws IOException {
        this.getBytes(4);
        return this.buffer_.getInt();
    }

    @Override
    public long getUInteger() throws IOException {
        this.getBytes(4);
        return (long)this.buffer_.getInt() & 0xFFFFFFFFL;
    }

    @Override
    public boolean getBoolean() throws IOException {
        int n = this.getInteger();
        switch (n) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        throw new IOException("Not boolean value");
    }

    @Override
    public long getHyper() throws IOException {
        this.getBytes(8);
        return this.buffer_.getLong();
    }

    @Override
    public BigInteger getUHyper() throws IOException {
        this.getBytes(8);
        byte[] byArray = new byte[8];
        this.buffer_.get(byArray);
        return new BigInteger(1, byArray);
    }

    @Override
    public float getFloat() throws IOException {
        this.getBytes(4);
        return this.buffer_.getFloat();
    }

    @Override
    public double getDouble() throws IOException {
        this.getBytes(8);
        return this.buffer_.getDouble();
    }

    @Override
    public byte[] getFixedOpaque(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.read(byArray, 0, n);
        this.bump(n);
        return byArray;
    }

    @Override
    public byte[] getOpaque() throws IOException {
        int n = this.getInteger();
        byte[] byArray = new byte[n];
        this.read(byArray, 0, n);
        this.bump(n);
        return byArray;
    }

    @Override
    public String getString() throws IOException {
        byte[] byArray = this.getOpaque();
        return new String(byArray);
    }
}

