/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.solaris.rad.encodings.xdr;

import com.oracle.solaris.rad.encodings.xdr.RecordMarkingStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class RecordMarkingInputStream
extends InputStream
implements RecordMarkingStream {
    private InputStream stream_;
    private int bytesLeft_ = 0;
    private int headerPos_ = 0;
    private boolean lastFrag_ = false;
    private ByteBuffer header_ = ByteBuffer.allocate(4);

    public RecordMarkingInputStream(InputStream inputStream) {
        this.stream_ = new BufferedInputStream(inputStream);
    }

    private boolean read_header() throws IOException {
        while (this.headerPos_ < 4) {
            int n = this.stream_.read();
            if (n == -1) {
                return false;
            }
            if (this.headerPos_ == 0) {
                this.lastFrag_ = (n & 0x80) != 0;
                n &= 0xFFFFFF7F;
            }
            this.header_.put(this.headerPos_++, (byte)n);
        }
        this.headerPos_ = 0;
        this.header_.rewind();
        this.bytesLeft_ = this.header_.getInt();
        return true;
    }

    @Override
    public int read() throws IOException {
        do {
            if (this.bytesLeft_ > 0) {
                int n = this.stream_.read();
                if (n != -1) {
                    --this.bytesLeft_;
                }
                return n;
            }
            if (!this.lastFrag_ || this.headerPos_ != 0) continue;
            return -1;
        } while (this.read_header());
        return -1;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        do {
            if (this.bytesLeft_ > 0) {
                int n3 = Math.min(this.bytesLeft_, n2);
                int n4 = this.stream_.read(byArray, n, n3);
                if (n4 > 0) {
                    this.bytesLeft_ -= n4;
                }
                return n4;
            }
            if (!this.lastFrag_ || this.headerPos_ != 0) continue;
            return -1;
        } while (this.read_header());
        return -1;
    }

    public boolean skipRecord() throws IOException {
        while (true) {
            if (this.bytesLeft_ > 0) {
                long l = this.stream_.skip(this.bytesLeft_);
                if (l <= 0L) {
                    return false;
                }
                this.bytesLeft_ = (int)((long)this.bytesLeft_ - l);
                continue;
            }
            if (this.lastFrag_) {
                this.lastFrag_ = false;
                return true;
            }
            if (!this.read_header()) break;
        }
        return false;
    }
}

