/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.solaris.rad.connect;

import com.oracle.solaris.rad.client.ProxyInterface;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class ZoneInputStream
extends InputStream {
    private Method read_;
    private Method available_;
    private Long token_;
    private ProxyInterface zobj_;

    ZoneInputStream(ProxyInterface proxyInterface, Long l) throws IOException {
        this.token_ = l;
        this.zobj_ = proxyInterface;
        try {
            this.read_ = proxyInterface.getClass().getMethod("read", Long.class, Integer.class);
            this.available_ = proxyInterface.getClass().getMethod("available", Long.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IOException(noSuchMethodException);
        }
    }

    @Override
    public int available() throws IOException {
        int n = 0;
        try {
            n = (Integer)this.available_.invoke((Object)this.zobj_, this.token_);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IOException(invocationTargetException);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2 = null;
        try {
            byArray2 = (byte[])this.read_.invoke((Object)this.zobj_, this.token_, n2);
            if (byArray2 == null) {
                return -1;
            }
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IOException(invocationTargetException);
        }
        return byArray2.length;
    }

    @Override
    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray, 0, 1);
        if (n > 0) {
            return byArray[0];
        }
        return n;
    }
}

