/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist;

import com.sleepycat.bind.EntityBinding;
import com.sleepycat.bind.EntryBinding;
import com.sleepycat.collections.StoredSortedMap;
import com.sleepycat.compat.DbCompat;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseConfig;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.LockMode;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.db.SecondaryDatabase;
import com.sleepycat.db.Transaction;
import com.sleepycat.db.TransactionConfig;
import com.sleepycat.persist.BasicIndex;
import com.sleepycat.persist.EntityIndex;
import com.sleepycat.persist.EntityValueAdapter;
import com.sleepycat.persist.KeysIndex;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.SubIndex;
import java.util.Map;
import java.util.SortedMap;

public class SecondaryIndex<SK, PK, E>
extends BasicIndex<SK, E> {
    private SecondaryDatabase secDb;
    private Database keysDb;
    private PrimaryIndex<PK, E> priIndex;
    private EntityBinding<E> entityBinding;
    private EntityIndex<SK, PK> keysIndex;
    private SortedMap<SK, E> map;

    public SecondaryIndex(SecondaryDatabase secondaryDatabase, Database database, PrimaryIndex<PK, E> primaryIndex, Class<SK> clazz, EntryBinding<SK> entryBinding) throws DatabaseException {
        super(secondaryDatabase, clazz, entryBinding, new EntityValueAdapter<E>(primaryIndex.getEntityClass(), primaryIndex.getEntityBinding(), true));
        this.secDb = secondaryDatabase;
        this.keysDb = database;
        this.priIndex = primaryIndex;
        this.entityBinding = primaryIndex.getEntityBinding();
    }

    public SecondaryDatabase getDatabase() {
        return this.secDb;
    }

    public Database getKeysDatabase() {
        return this.keysDb;
    }

    public PrimaryIndex<PK, E> getPrimaryIndex() {
        return this.priIndex;
    }

    public Class<SK> getKeyClass() {
        return this.keyClass;
    }

    public EntryBinding<SK> getKeyBinding() {
        return this.keyBinding;
    }

    public synchronized EntityIndex<SK, PK> keysIndex() throws DatabaseException {
        if (this.keysIndex == null) {
            if (this.keysDb == null) {
                DatabaseConfig databaseConfig = this.secDb.getConfig();
                databaseConfig.setReadOnly(true);
                databaseConfig.setAllowCreate(false);
                databaseConfig.setExclusiveCreate(false);
                this.keysDb = DbCompat.openDatabase(this.db.getEnvironment(), null, DbCompat.getDatabaseFile(this.secDb), this.secDb.getDatabaseName(), databaseConfig);
                if (this.keysDb == null) {
                    throw new IllegalStateException("Could not open existing DB, file: " + DbCompat.getDatabaseFile(this.secDb) + " name: " + this.secDb.getDatabaseName());
                }
            }
            this.keysIndex = new KeysIndex(this.keysDb, this.keyClass, this.keyBinding, this.priIndex.getKeyClass(), this.priIndex.getKeyBinding());
        }
        return this.keysIndex;
    }

    public EntityIndex<PK, E> subIndex(SK SK) throws DatabaseException {
        return new SubIndex(this, this.entityBinding, SK);
    }

    @Override
    public E get(SK SK) throws DatabaseException {
        return this.get((Transaction)null, SK, (LockMode)null);
    }

    @Override
    public E get(Transaction transaction, SK SK, LockMode lockMode) throws DatabaseException {
        DatabaseEntry databaseEntry = new DatabaseEntry();
        DatabaseEntry databaseEntry2 = new DatabaseEntry();
        DatabaseEntry databaseEntry3 = new DatabaseEntry();
        this.keyBinding.objectToEntry(SK, databaseEntry);
        OperationStatus operationStatus = this.secDb.get(transaction, databaseEntry, databaseEntry2, databaseEntry3, lockMode);
        if (operationStatus == OperationStatus.SUCCESS) {
            return this.entityBinding.entryToObject(databaseEntry2, databaseEntry3);
        }
        return null;
    }

    @Override
    public Map<SK, E> map() {
        return this.sortedMap();
    }

    @Override
    public synchronized SortedMap<SK, E> sortedMap() {
        if (this.map == null) {
            this.map = new StoredSortedMap<SK, E>(this.db, this.keyBinding, this.entityBinding, true);
        }
        return this.map;
    }

    TransactionConfig getAutoCommitTransactionConfig() {
        return null;
    }

    @Override
    boolean isUpdateAllowed() {
        return false;
    }
}

