/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.ReplicationHostAddress;
import com.sleepycat.db.internal.DbSite;

public class ReplicationManagerSiteConfig
implements Cloneable {
    private String host = null;
    private long port = 0L;
    private boolean helper = false;
    private boolean groupCreator = false;
    private boolean legacy = false;
    private boolean localSite = false;
    private boolean peer = false;

    public ReplicationManagerSiteConfig() {
    }

    public ReplicationManagerSiteConfig(String string, long l) {
        this.host = string;
        this.port = l;
    }

    public void setAddress(ReplicationHostAddress replicationHostAddress) {
        this.host = replicationHostAddress.host;
        this.port = replicationHostAddress.port;
    }

    public ReplicationHostAddress getAddress() {
        ReplicationHostAddress replicationHostAddress = new ReplicationHostAddress();
        if (this.host != null && this.port != 0L) {
            replicationHostAddress.host = this.host;
            replicationHostAddress.port = (int)this.port;
        }
        return replicationHostAddress;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public String getHost() {
        return this.host;
    }

    public void setPort(long l) {
        this.port = l;
    }

    public long getPort() {
        return this.port;
    }

    public void setBootstrapHelper(boolean bl) {
        this.helper = bl;
    }

    public boolean getBootstrapHelper() {
        return this.helper;
    }

    public void setGroupCreator(boolean bl) {
        this.groupCreator = bl;
    }

    public boolean getGroupCreator() {
        return this.groupCreator;
    }

    public void setLegacy(boolean bl) {
        this.legacy = bl;
    }

    public boolean getLegacy() {
        return this.legacy;
    }

    public void setLocalSite(boolean bl) {
        this.localSite = bl;
    }

    public boolean getLocalSite() {
        return this.localSite;
    }

    public void setPeer(boolean bl) {
        this.peer = bl;
    }

    public boolean getPeer() {
        return this.peer;
    }

    ReplicationManagerSiteConfig(DbSite dbSite) throws DatabaseException {
        ReplicationHostAddress replicationHostAddress = dbSite.get_address();
        this.host = replicationHostAddress.host;
        this.port = replicationHostAddress.port;
        this.helper = dbSite.get_config(1);
        this.groupCreator = dbSite.get_config(2);
        this.legacy = dbSite.get_config(4);
        this.localSite = dbSite.get_config(8);
        this.peer = dbSite.get_config(16);
    }
}

