/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.math.BigInteger;
import java.security.AccessController;
import java.security.AlgorithmConstraints;
import java.security.CryptoPrimitive;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import javax.net.ssl.SSLHandshakeException;
import sun.security.ssl.Debug;
import sun.security.ssl.JsseJce;
import sun.security.util.KeyUtil;

final class DHCrypt {
    private BigInteger modulus;
    private BigInteger base;
    private PrivateKey privateKey;
    private BigInteger publicValue;
    private static int MAX_FAILOVER_TIMES = 2;

    DHCrypt(int n, SecureRandom secureRandom) {
        this(n, (DHParameterSpec)ParametersHolder.definedParams.get(n), secureRandom);
    }

    DHCrypt(BigInteger bigInteger, BigInteger bigInteger2, SecureRandom secureRandom) {
        this(bigInteger.bitLength(), new DHParameterSpec(bigInteger, bigInteger2), secureRandom);
    }

    private DHCrypt(int n, DHParameterSpec dHParameterSpec, SecureRandom secureRandom) {
        try {
            KeyPairGenerator keyPairGenerator = JsseJce.getKeyPairGenerator("DiffieHellman");
            if (dHParameterSpec != null) {
                keyPairGenerator.initialize(dHParameterSpec, secureRandom);
            } else {
                keyPairGenerator.initialize(n, secureRandom);
            }
            DHPublicKeySpec dHPublicKeySpec = this.generateDHPublicKeySpec(keyPairGenerator);
            if (dHPublicKeySpec == null) {
                throw new RuntimeException("Could not generate DH keypair");
            }
            this.publicValue = dHPublicKeySpec.getY();
            this.modulus = dHPublicKeySpec.getP();
            this.base = dHPublicKeySpec.getG();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RuntimeException("Could not generate DH keypair", generalSecurityException);
        }
    }

    static DHPublicKeySpec getDHPublicKeySpec(PublicKey publicKey) {
        if (publicKey instanceof DHPublicKey) {
            DHPublicKey dHPublicKey = (DHPublicKey)publicKey;
            DHParameterSpec dHParameterSpec = dHPublicKey.getParams();
            return new DHPublicKeySpec(dHPublicKey.getY(), dHParameterSpec.getP(), dHParameterSpec.getG());
        }
        try {
            KeyFactory keyFactory = JsseJce.getKeyFactory("DH");
            return keyFactory.getKeySpec(publicKey, DHPublicKeySpec.class);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    BigInteger getModulus() {
        return this.modulus;
    }

    BigInteger getBase() {
        return this.base;
    }

    BigInteger getPublicKey() {
        return this.publicValue;
    }

    SecretKey getAgreedSecret(BigInteger bigInteger, boolean bl) throws SSLHandshakeException {
        try {
            KeyFactory keyFactory = JsseJce.getKeyFactory("DiffieHellman");
            DHPublicKeySpec dHPublicKeySpec = new DHPublicKeySpec(bigInteger, this.modulus, this.base);
            PublicKey publicKey = keyFactory.generatePublic(dHPublicKeySpec);
            KeyAgreement keyAgreement = JsseJce.getKeyAgreement("DiffieHellman");
            if (!bl && !KeyUtil.isOracleJCEProvider(keyAgreement.getProvider().getName())) {
                try {
                    KeyUtil.validate(dHPublicKeySpec);
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new SSLHandshakeException(invalidKeyException.getMessage());
                }
            }
            keyAgreement.init(this.privateKey);
            keyAgreement.doPhase(publicKey, true);
            return keyAgreement.generateSecret("TlsPremasterSecret");
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw (SSLHandshakeException)new SSLHandshakeException("Could not generate secret").initCause(generalSecurityException);
        }
    }

    void checkConstraints(AlgorithmConstraints algorithmConstraints, BigInteger bigInteger) throws SSLHandshakeException {
        try {
            KeyFactory keyFactory = JsseJce.getKeyFactory("DiffieHellman");
            DHPublicKeySpec dHPublicKeySpec = new DHPublicKeySpec(bigInteger, this.modulus, this.base);
            DHPublicKey dHPublicKey = (DHPublicKey)keyFactory.generatePublic(dHPublicKeySpec);
            if (!algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), dHPublicKey)) {
                throw new SSLHandshakeException("DHPublicKey does not comply to algorithm constraints");
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw (SSLHandshakeException)new SSLHandshakeException("Could not generate DHPublicKey").initCause(generalSecurityException);
        }
    }

    private DHPublicKeySpec generateDHPublicKeySpec(KeyPairGenerator keyPairGenerator) throws GeneralSecurityException {
        boolean bl = !KeyUtil.isOracleJCEProvider(keyPairGenerator.getProvider().getName());
        for (int i = 0; i <= MAX_FAILOVER_TIMES; ++i) {
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            this.privateKey = keyPair.getPrivate();
            DHPublicKeySpec dHPublicKeySpec = DHCrypt.getDHPublicKeySpec(keyPair.getPublic());
            if (bl) {
                try {
                    KeyUtil.validate(dHPublicKeySpec);
                }
                catch (InvalidKeyException invalidKeyException) {
                    if (i != MAX_FAILOVER_TIMES) continue;
                    throw invalidKeyException;
                }
            }
            return dHPublicKeySpec;
        }
        return null;
    }

    private static class ParametersHolder {
        private static final boolean debugIsOn;
        private static final BigInteger g2;
        private static final BigInteger p512;
        private static final BigInteger p768;
        private static final BigInteger p1024;
        private static final BigInteger p2048;
        private static final BigInteger[] supportedPrimes;
        private static final int PRIME_CERTAINTY = 120;
        private static final String PROPERTY_NAME = "jdk.tls.server.defaultDHEParameters";
        private static final Pattern spacesPattern;
        private static final Pattern syntaxPattern;
        private static final Pattern paramsPattern;
        private static final Map<Integer, DHParameterSpec> definedParams;

        private ParametersHolder() {
        }

        static {
            Object object;
            debugIsOn = Debug.getInstance("ssl") != null && Debug.isOn("sslctx");
            g2 = BigInteger.valueOf(2L);
            p512 = new BigInteger("D87780E15FF50B4ABBE89870188B049406B5BEA98AB23A0241D88EA75B7755E669C08093D3F0CA7FC3A5A25CF067DCB9A43DD89D1D90921C6328884461E0B6D3", 16);
            p768 = new BigInteger("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A63A3620FFFFFFFFFFFFFFFF", 16);
            p1024 = new BigInteger("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE65381FFFFFFFFFFFFFFFF", 16);
            p2048 = new BigInteger("FFFFFFFFFFFFFFFFADF85458A2BB4A9AAFDC5620273D3CF1D8B9C583CE2D3695A9E13641146433FBCC939DCE249B3EF97D2FE363630C75D8F681B202AEC4617AD3DF1ED5D5FD65612433F51F5F066ED0856365553DED1AF3B557135E7F57C935984F0C70E0E68B77E2A689DAF3EFE8721DF158A136ADE73530ACCA4F483A797ABC0AB182B324FB61D108A94BB2C8E3FBB96ADAB760D7F4681D4F42A3DE394DF4AE56EDE76372BB190B07A7C8EE0A6D709E02FCE1CDF7E2ECC03404CD28342F619172FE9CE98583FF8E4F1232EEF28183C3FE3B1B4C6FAD733BB5FCBC2EC22005C58EF1837D1683B2C6F34A26C1B2EFFA886B423861285C97FFFFFFFFFFFFFFFF", 16);
            supportedPrimes = new BigInteger[]{p512, p768, p1024, p2048};
            spacesPattern = Pattern.compile("\\s+");
            syntaxPattern = Pattern.compile("(\\{[0-9A-Fa-f]+,[0-9A-Fa-f]+\\})(,\\{[0-9A-Fa-f]+,[0-9A-Fa-f]+\\})*");
            paramsPattern = Pattern.compile("\\{([0-9A-Fa-f]+),([0-9A-Fa-f]+)\\}");
            String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return Security.getProperty(ParametersHolder.PROPERTY_NAME);
                }
            });
            if (string != null && !string.isEmpty()) {
                if (string.length() >= 2 && string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
                    string = string.substring(1, string.length() - 1);
                }
                string = string.trim();
            }
            if (string != null && !string.isEmpty()) {
                object = spacesPattern.matcher(string);
                string = ((Matcher)object).replaceAll("");
                if (debugIsOn) {
                    System.out.println("The Security Property jdk.tls.server.defaultDHEParameters: " + string);
                }
            }
            object = new HashMap();
            if (string != null && !string.isEmpty()) {
                Matcher matcher = syntaxPattern.matcher(string);
                if (matcher.matches()) {
                    Matcher matcher2 = paramsPattern.matcher(string);
                    while (matcher2.find()) {
                        String string2 = matcher2.group(1);
                        BigInteger object2 = new BigInteger(string2, 16);
                        if (!object2.isProbablePrime(120)) {
                            if (!debugIsOn) continue;
                            System.out.println("Prime modulus p in Security Property, jdk.tls.server.defaultDHEParameters, is not a prime: " + string2);
                            continue;
                        }
                        String string3 = matcher2.group(2);
                        BigInteger bigInteger = new BigInteger(string3, 16);
                        DHParameterSpec dHParameterSpec = new DHParameterSpec(object2, bigInteger);
                        int n = object2.bitLength();
                        object.put(n, dHParameterSpec);
                    }
                } else if (debugIsOn) {
                    System.out.println("Invalid Security Property, jdk.tls.server.defaultDHEParameters, definition");
                }
            }
            for (BigInteger bigInteger : supportedPrimes) {
                int n = bigInteger.bitLength();
                if (object.get(n) != null) continue;
                object.put(n, new DHParameterSpec(bigInteger, g2));
            }
            definedParams = Collections.unmodifiableMap(object);
        }
    }
}

