/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.BuiltInProperties;
import com.sun.deploy.config.ClientConfig;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.Platform;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.TrustDecider;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.VersionID;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class SecurityBaseline {
    private static final int NEW_UPDATE_DOWNLOADED = 0;
    private static final int UPDATE_NOT_REQUIRED = 1;
    private static final int UPDATE_CHECK_FAILED = 2;
    private static String baseline_131 = "1.3.1_21";
    private static String baseline_142 = "1.4.2_43";
    private static String baseline_150 = "1.5.0_99";
    private static String baseline_160 = "1.6.0_121";
    private static String baseline_170 = "1.7.0_111";
    private static String baseline_180 = "1.8.0_101";
    private static volatile boolean baselines_initialized = false;
    private static final boolean DEBUG = Config.getBooleanProperty("deployment.baseline.debug");
    private static final long UPDATE_INTERVAL = DEBUG ? 10000 : 86400000;
    private static final long THREAD_SLEEP_INTERVAL = DEBUG ? 1000 : 30000;
    private static final String BASELINE_FILENAME = "baseline.versions";
    private static final String SECURITY_PACK_FILENAME = "securitypack.jar";
    private static final String DYNAMIC_BLACKLIST_FILENAME = "blacklist.dynamic";
    private static final String BLACKLIST_CERT_FILENAME = "blacklisted.certs";
    private static final String UPDATE_TIMESTAMP = "update.securitypack.timestamp";
    private static final File securityDir = new File(Config.getUserHome(), "security");
    private static final File securityPackFile = new File(securityDir, "securitypack.jar");
    private static final File baselineFile = new File(securityDir, "baseline.versions");
    private static final File blacklistFile = new File(Config.getDynamicBlacklistFile());
    private static final File blacklistCertsFile = new File(Config.getDynamicBlacklistCertsFile());
    private static final File updateTimestampFile = new File(securityDir, "update.securitypack.timestamp");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void initialize_baselines() {
        block20: {
            if (!baselines_initialized && baselineFile.exists()) {
                BufferedReader bufferedReader;
                block19: {
                    bufferedReader = null;
                    long l = System.currentTimeMillis();
                    bufferedReader = new BufferedReader(new FileReader(baselineFile));
                    boolean bl = false;
                    while (!bl) {
                        String string = bufferedReader.readLine();
                        if (string == null) {
                            bl = true;
                            continue;
                        }
                        if (string.startsWith("1.8")) {
                            baseline_180 = string;
                            Platform.get().cacheSecurityBaseline("1.8.0", baseline_180);
                            continue;
                        }
                        if (string.startsWith("1.7")) {
                            baseline_170 = string;
                            Platform.get().cacheSecurityBaseline("1.7.0", baseline_170);
                            continue;
                        }
                        if (string.startsWith("1.6")) {
                            baseline_160 = string;
                            Platform.get().cacheSecurityBaseline("1.6.0", baseline_160);
                            continue;
                        }
                        if (string.startsWith("1.5")) {
                            baseline_150 = string;
                            Platform.get().cacheSecurityBaseline("1.5.0", baseline_150);
                            continue;
                        }
                        if (string.startsWith("1.4.2")) {
                            baseline_142 = string;
                            Platform.get().cacheSecurityBaseline("1.4.2", baseline_142);
                            continue;
                        }
                        if (!string.startsWith("1.3.1")) continue;
                        baseline_131 = string;
                        Platform.get().cacheSecurityBaseline("1.3.1", baseline_131);
                    }
                    if (!DEBUG) break block19;
                    Trace.println("It took " + (System.currentTimeMillis() - l) + " Ms. to read baseline file", TraceLevel.BASIC);
                }
                Object var6_5 = null;
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    break block20;
                }
                catch (IOException iOException) {
                    Trace.ignored(iOException);
                }
                break block20;
                {
                    catch (Exception exception) {
                        Trace.ignored(exception);
                        Object var6_6 = null;
                        try {
                            if (bufferedReader != null) {
                                bufferedReader.close();
                            }
                            break block20;
                        }
                        catch (IOException iOException) {
                            Trace.ignored(iOException);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                    }
                    catch (IOException iOException) {
                        Trace.ignored(iOException);
                    }
                    throw throwable;
                }
            }
        }
        baselines_initialized = true;
    }

    public static String getBaselineVersion(String string) {
        if (!baselines_initialized) {
            SecurityBaseline.initialize_baselines();
        }
        String string2 = string.startsWith("1.8") ? baseline_180 : (string.startsWith("1.7") ? baseline_170 : (string.startsWith("1.6") ? baseline_160 : (string.startsWith("1.5") ? baseline_150 : (string.startsWith("1.4.2") ? baseline_142 : (string.startsWith("1.3.1") ? baseline_131 : "1.7.0_111")))));
        if (DEBUG) {
            Trace.println("for requested version: " + string + "baseline version is: " + string2, TraceLevel.SECURITY);
        }
        return string2;
    }

    public static boolean satisfiesSecurityBaseline(String string) {
        if (!Config.isExpirationCheckEnabled()) {
            return true;
        }
        VersionID versionID = new VersionID(string);
        VersionID versionID2 = new VersionID(SecurityBaseline.getBaselineVersion(string));
        if (versionID.isGreaterThanOrEqual(versionID2)) {
            return true;
        }
        return versionID.equals(JREInfo.getLatestVersion(true));
    }

    public static boolean satisfiesBaselineStrictly(String string) {
        return SecurityBaseline.satisfiesBaselineStrictly(string, SecurityBaseline.getBaselineVersion(string));
    }

    public static boolean satisfiesBaselineStrictly(String string, String string2) {
        if (!SecurityBaseline.getBaselineVersion(string).equals(string2)) {
            return false;
        }
        if (!Config.isExpirationCheckEnabled()) {
            return true;
        }
        int n = (string = string.replace(".ea", "-ea")).indexOf("-");
        String string3 = n > 0 ? string.substring(0, n) : string;
        VersionID versionID = new VersionID(string3);
        VersionID versionID2 = new VersionID(string2);
        boolean bl = versionID.isGreaterThanOrEqual(versionID2);
        if (DEBUG) {
            Trace.println("strictly satisfied=" + bl + "  for version: " + string + "  baseline is: " + SecurityBaseline.getBaselineVersion(string));
        }
        return bl;
    }

    public static String getDeployVersion() {
        return "10.111.0.13";
    }

    public static String getDeployNoBuildVersion() {
        return "10.111.0";
    }

    public static String getDeployNoDotVersion() {
        return "101110";
    }

    public static String getCurrentVersion() {
        return "1.7.0_111";
    }

    public static String getCurrentNoDotVersion() {
        return "170";
    }

    private static synchronized void checkForUpdates(boolean bl) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                int n = SecurityBaseline.checkForUpdate(Config.getStringProperty("deployment.baseline.url"), securityPackFile);
                if (n == 0) {
                    Config config;
                    SecurityBaseline.verifyJar(securityPackFile);
                    SecurityBaseline.extractManifests();
                    baselines_initialized = false;
                    SecurityBaseline.initialize_baselines();
                    if (SecurityBaseline.isExpired() && (config = Config.get()) instanceof ClientConfig) {
                        ((ClientConfig)config).storeConfig();
                    }
                }
                if (n != 2) {
                    SecurityBaseline.setLastChecked(new Date().getTime());
                }
            }
        });
        thread.setDaemon(!bl);
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            Trace.ignored(interruptedException);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void extractManifests() {
        JarFile jarFile = null;
        jarFile = new JarFile(securityPackFile, false);
        SecurityBaseline.extractManifest(jarFile, BASELINE_FILENAME, baselineFile);
        SecurityBaseline.extractManifest(jarFile, BLACKLIST_CERT_FILENAME, blacklistCertsFile);
        SecurityBaseline.extractManifest(jarFile, DYNAMIC_BLACKLIST_FILENAME, blacklistFile);
        Object var4_1 = null;
        if (jarFile == null) return;
        try {
            jarFile.close();
            return;
        }
        catch (IOException iOException) {
            Trace.ignored(iOException);
        }
        return;
        {
            catch (IOException iOException) {
                String string = "Manifest extractions failed for signed security pack file " + securityPackFile;
                Trace.println(string, TraceLevel.SECURITY);
                throw new SecurityException(string, iOException);
            }
        }
        catch (Throwable throwable) {
            Object var4_2 = null;
            if (jarFile == null) throw throwable;
            try {
                jarFile.close();
                throw throwable;
            }
            catch (IOException iOException) {
                Trace.ignored(iOException);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static void verifyJar(File var0) {
        if (Config.isJavaVersionAtLeast16()) {
            block29: {
                var1_1 = new HashSet<CodeSigner>();
                var2_2 = null;
                var3_3 = new String[]{"baseline.versions", "blacklisted.certs", "blacklist.dynamic"};
                var4_4 = null;
                var5_5 /* !! */  = null;
                try {
                    block28: {
                        var2_2 = new JarFile(var0);
                        for (var6_6 = 0; var6_6 < var3_3.length; ++var6_6) {
                            var7_9 = var3_3[var6_6];
                            var8_10 = null;
                            try {
                                var9_11 = var2_2.getJarEntry((String)var7_9);
                                if (var9_11 == null) {
                                    var10_12 /* !! */  = (byte[])("Verification failed for signed security pack file " + var0 + ", missing entry " + (String)var7_9);
                                    Trace.println((String)var10_12 /* !! */ , TraceLevel.SECURITY);
                                    throw new SecurityException((String)var10_12 /* !! */ , null);
                                }
                                var8_10 = var2_2.getInputStream((ZipEntry)var9_11);
                                var10_12 /* !! */  = new byte[1024];
                                while ((var11_13 = var8_10.read(var10_12 /* !! */ )) != -1) {
                                }
                                if (var9_11.getCodeSigners() != null) {
                                    var12_14 = var9_11.getCodeSigners();
                                    for (var13_15 = 0; var13_15 < var12_14.length; ++var13_15) {
                                        var1_1.add(var12_14[var13_15]);
                                    }
                                }
                                var15_16 = null;
                                if (var8_10 == null) continue;
                            }
                            catch (Throwable var14_18) {
                                var15_16 = null;
                                if (var8_10 != null) {
                                    try {
                                        var8_10.close();
                                    }
                                    catch (IOException var16_17) {
                                        Trace.ignored(var16_17);
                                    }
                                }
                                throw var14_18;
                            }
                            try {
                                var8_10.close();
                            }
                            catch (IOException var16_17) {
                                Trace.ignored(var16_17);
                            }
                        }
                        var6_7 = var1_1.toArray(new CodeSigner[var1_1.size()]);
                        var7_9 = var0.toURI().toURL();
                        var8_10 = new CodeSource((URL)var7_9, var6_7);
                        var9_11 = TrustDecider.getJarValidationState((CodeSource)var8_10, null, null);
                        if (var9_11.trustDecision == 0L) {
                            var4_4 = "deployment.securitypack.cannot.validate";
                            break block28;
                        }
                        if (var9_11.certValidity != 0) {
                            var4_4 = "deployment.securitypack.cannot.validate";
                            break block28;
                        }
                        if (!var9_11.rootCAValid) {
                            var4_4 = "deployment.securitypack.cannot.validate.selfsigned";
                            break block28;
                        }
                        if (var9_11.timeValid) break block28;
                        var4_4 = "deployment.securitypack.cannot.validate.expired";
                        var5_5 /* !! */  = var9_11.certExpiredException != null ? var9_11.certExpiredException : var9_11.certNotYetValidException;
                    }
                    var18_19 = null;
                    ** if (var2_2 == null) goto lbl-1000
                }
                catch (Throwable var17_25) {
                    var18_21 = null;
                    if (var2_2 != null) {
                        try {
                            var2_2.close();
                        }
                        catch (IOException var19_24) {
                            Trace.ignored(var19_24);
                        }
                    }
                    throw var17_25;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        var2_2.close();
                    }
                    catch (IOException var19_22) {
                        Trace.ignored(var19_22);
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block29;
                    catch (IOException var6_8) {
                        var4_4 = "deployment.securitypack.cannot.validate.exception";
                        var5_5 /* !! */  = var6_8;
                        var18_20 = null;
                        if (var2_2 != null) {
                            try {
                                var2_2.close();
                            }
                            catch (IOException var19_23) {
                                Trace.ignored(var19_23);
                            }
                        }
                    }
                }
            }
            if (var4_4 != null) {
                Trace.println("Verification failed for signed security pack file " + var0, TraceLevel.SECURITY);
                throw new SecurityException(ResourceManager.getMessage(var4_4), var5_5 /* !! */ );
            }
            Trace.println("Verification succeeded for signed security pack file " + var0, TraceLevel.SECURITY);
        } else {
            Trace.println("Security pack verification skipped - not running JDK6 or later", TraceLevel.SECURITY);
        }
    }

    /*
     * Loose catch block
     */
    private static void extractManifest(JarFile jarFile, String string, File file) {
        block16: {
            IOException iOException2222;
            FileOutputStream fileOutputStream;
            InputStream inputStream;
            block15: {
                int n;
                inputStream = null;
                fileOutputStream = null;
                JarEntry jarEntry = jarFile.getJarEntry(string);
                if (jarEntry == null) {
                    String string2 = "Missing  entry " + string;
                    Trace.println(string2, TraceLevel.SECURITY);
                    throw new SecurityException(string2, null);
                }
                inputStream = jarFile.getInputStream(jarEntry);
                fileOutputStream = new FileOutputStream(file);
                byte[] byArray = new byte[1024];
                while ((n = inputStream.read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n);
                }
                Object var9_11 = null;
                if (fileOutputStream == null) break block15;
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException2222) {
                    Trace.ignored(iOException2222);
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException2222) {
                    Trace.ignored(iOException2222);
                }
            }
            break block16;
            {
                catch (IOException iOException3) {
                    String string3 = "Failed to extract " + string;
                    Trace.println(string3, TraceLevel.SECURITY);
                    throw new SecurityException(string3, iOException3);
                }
            }
            catch (Throwable throwable) {
                IOException iOException42222;
                Object var9_12 = null;
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException42222) {
                        Trace.ignored(iOException42222);
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException42222) {
                        Trace.ignored(iOException42222);
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static int checkForUpdate(String string, File file) {
        int n;
        block27: {
            n = 1;
            if (string != null && string.length() > 0) {
                Exception exception2222;
                FileOutputStream fileOutputStream;
                InputStream inputStream;
                long l;
                block24: {
                    block23: {
                        int n2;
                        long l2 = 0L;
                        l = 0L;
                        if (file.exists()) {
                            l2 = file.lastModified();
                        }
                        inputStream = null;
                        fileOutputStream = null;
                        Trace.println("Checking for update at: " + string, TraceLevel.NETWORK);
                        URL uRL = new URL(string);
                        URLConnection uRLConnection = uRL.openConnection();
                        uRLConnection.setUseCaches(false);
                        l = uRLConnection.getLastModified();
                        if (l < l2) break block23;
                        Trace.println("Updating file at: " + file + " from url: " + string, TraceLevel.NETWORK);
                        inputStream = uRLConnection.getInputStream();
                        fileOutputStream = new FileOutputStream(file);
                        byte[] byArray = new byte[8192];
                        while ((n2 = inputStream.read(byArray)) != -1) {
                            fileOutputStream.write(byArray, 0, n2);
                        }
                        n = 0;
                    }
                    Object var14_12 = null;
                    if (fileOutputStream == null) break block24;
                    try {
                        fileOutputStream.close();
                    }
                    catch (Exception exception2222) {
                        Trace.ignored(exception2222);
                    }
                    if (l > 0L) {
                        file.setLastModified(l);
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception2222) {
                        Trace.ignored(exception2222);
                    }
                }
                break block27;
                {
                    catch (Exception exception3) {
                        Exception exception42222;
                        n = 2;
                        Trace.ignored(exception3);
                        Object var14_13 = null;
                        if (fileOutputStream != null) {
                            try {
                                fileOutputStream.close();
                            }
                            catch (Exception exception42222) {
                                Trace.ignored(exception42222);
                            }
                            if (l > 0L) {
                                file.setLastModified(l);
                            }
                        }
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Exception exception42222) {
                                Trace.ignored(exception42222);
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    Exception exception52222;
                    Object var14_14 = null;
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (Exception exception52222) {
                            Trace.ignored(exception52222);
                        }
                        if (l > 0L) {
                            file.setLastModified(l);
                        }
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception52222) {
                            Trace.ignored(exception52222);
                        }
                    }
                    throw throwable;
                }
            }
        }
        return n;
    }

    private static long getLastChecked() {
        if (updateTimestampFile.exists()) {
            return updateTimestampFile.lastModified();
        }
        return 0L;
    }

    private static void setLastChecked(long l) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(updateTimestampFile);
            ((OutputStream)fileOutputStream).write(46);
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void backgroundUpdate() {
        if (Platform.get().isNativeSandbox()) {
            return;
        }
        Thread thread = new Thread(new Runnable(){

            public void run() {
                long l = new Date().getTime();
                if (l > SecurityBaseline.getLastChecked() + UPDATE_INTERVAL) {
                    try {
                        Thread.sleep(THREAD_SLEEP_INTERVAL);
                        SecurityBaseline.checkForUpdates(false);
                    }
                    catch (Exception exception) {
                        Trace.ignored(exception);
                    }
                }
                if (DEBUG) {
                    Trace.println("Baseline/Blacklist thread exiting time: " + (new Date().getTime() - l), TraceLevel.BASIC);
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    public static void forceBaselineUpdate() {
        SecurityBaseline.checkForUpdates(true);
        SecurityBaseline.initialize_baselines();
    }

    public static boolean isExpired() {
        Comparable<Date> comparable;
        if (!Config.isExpirationCheckEnabled()) {
            return false;
        }
        if (Config.isJavaVersionAtLeast15() && (comparable = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (System.getenv("JRE_NOTEXPIRED") != null) {
                    return Boolean.FALSE;
                }
                if (System.getenv("JRE_EXPIRED") != null) {
                    return Boolean.TRUE;
                }
                return null;
            }
        })) != null) {
            return (Boolean)comparable;
        }
        comparable = new Date(BuiltInProperties.expirationTime);
        if (((Date)comparable).before(new Date())) {
            return true;
        }
        return !SecurityBaseline.satisfiesBaselineStrictly(JREInfo.getLatest());
    }

    static {
        securityDir.mkdirs();
        SecurityBaseline.backgroundUpdate();
    }
}

