/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.proxy;

import com.sun.deploy.net.proxy.AbstractAutoProxyHandler;
import com.sun.deploy.net.proxy.BrowserProxyInfo;
import com.sun.deploy.net.proxy.ProxyConfigException;
import com.sun.deploy.net.proxy.ProxyInfo;
import com.sun.deploy.net.proxy.ProxyUnavailableException;
import com.sun.deploy.net.proxy.pac.PACFunctions;
import com.sun.deploy.net.proxy.pac.PACFunctionsImpl;
import com.sun.deploy.security.SelectableSecurityManager;
import com.sun.deploy.trace.Trace;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.StringTokenizer;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

public class SunAutoProxyHandler
extends AbstractAutoProxyHandler {
    private SelectableSecurityManager ssm = SelectableSecurityManager.getInstance();
    private ScriptEngineManager manager = null;
    private ScriptEngine engine = null;
    private static final AccessControlContext scriptEngineACC;
    private PACFunctions functionsImpl = null;
    private static final String pacFuncsImpl = "    function dnsResolve(host){\n                                     return String(obj.dnsResolve(host));\n                   }\n                                                          function isResolvable(host){\n                                   return obj.isResolvable(host);\n                         }\n                                                          function localHostOrDomainIs(host, domain){\n                    return obj.localHostOrDomainIs(host, domain);\n          }\n                                                          function isPlainHostName(host){\n                                return obj.isPlainHostName(host);\n                      }\n                                                          function myIpAddress(){\n                                        return String(obj.myIpAddress());\n                      }\n                                                          function shExpMatch(str, shexp){\n                               return obj.shExpMatch(str, shexp);\n                     }\n                                                          function dnsDomainIs(host, domain){\n                            return obj.dnsDomainIs(host, domain);\n                  }\n                                                          function dnsDomainLevels(host){\n                                return obj.dnsDomainLevels(host);\n                      }";

    public SunAutoProxyHandler() {
        this.functionsImpl = new PACFunctionsImpl();
    }

    public SunAutoProxyHandler(PACFunctions pACFunctions) {
        this.functionsImpl = pACFunctions;
    }

    public final void init(BrowserProxyInfo browserProxyInfo) throws ProxyConfigException {
        super.init(browserProxyInfo);
        this.initEngine(scriptEngineACC);
    }

    private void initEngine(AccessControlContext accessControlContext) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SunAutoProxyHandler.this.initEngine();
                return null;
            }
        }, accessControlContext);
    }

    private void initEngine() {
        this.manager = new ScriptEngineManager(null);
        this.engine = this.manager.getEngineByName("js");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProxyInfo[] getProxyInfo(URL uRL) throws ProxyUnavailableException {
        ProxyInfo[] proxyInfoArray = null;
        try {
            this.ssm.enable();
            proxyInfoArray = this.jsGetProxyInfo(uRL, scriptEngineACC);
            Object var4_3 = null;
            this.ssm.disable();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.ssm.disable();
            throw throwable;
        }
        if (proxyInfoArray == null) {
            proxyInfoArray = this.fallbackGetProxyInfo(uRL);
        }
        return proxyInfoArray;
    }

    private ProxyInfo[] jsGetProxyInfo(final URL uRL, AccessControlContext accessControlContext) {
        return (ProxyInfo[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return SunAutoProxyHandler.this.jsGetProxyInfo(uRL);
            }
        }, accessControlContext);
    }

    private ProxyInfo[] jsGetProxyInfo(URL uRL) {
        ProxyInfo[] proxyInfoArray = null;
        if (this.engine != null) {
            try {
                this.bindPACFunctions(this.engine);
                this.engine.eval(this.autoProxyScript.toString());
                if (this.engine instanceof Invocable) {
                    Invocable invocable = (Invocable)((Object)this.engine);
                    Object object = invocable.invokeFunction("FindProxyForURL", uRL.toString(), uRL.getHost());
                    proxyInfoArray = this.extractAutoProxySetting((String)object);
                } else {
                    Trace.netPrintln("JavaScript engine cannot invoke methods");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return proxyInfoArray;
    }

    private void bindPACFunctions(ScriptEngine scriptEngine) {
        scriptEngine.put("obj", this.functionsImpl);
    }

    protected String getBrowserSpecificAutoProxy() {
        return pacFuncsImpl;
    }

    ProxyInfo[] fallbackGetProxyInfo(URL uRL) {
        try {
            String string = null;
            if (this.jsPacScript != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.jsPacScript, ";", false);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    int n = string2.indexOf("DIRECT");
                    int n2 = string2.indexOf("PROXY");
                    int n3 = string2.indexOf("SOCKS");
                    int n4 = this.positiveMin(n, this.positiveMin(n2, n3));
                    int n5 = string2.lastIndexOf("\"");
                    if (n4 == -1) continue;
                    string = n5 <= n4 ? string2.substring(n4) : string2.substring(n4, n5);
                    break;
                }
            }
            return this.extractAutoProxySetting(string);
        }
        catch (Throwable throwable) {
            Trace.msgNetPrintln("net.proxy.auto.result.error");
            return new ProxyInfo[]{new ProxyInfo(null)};
        }
    }

    private int positiveMin(int n, int n2) {
        if (n < 0) {
            return n2;
        }
        if (n2 < 0) {
            return n;
        }
        if (n > n2) {
            return n2;
        }
        return n;
    }

    static {
        Permissions permissions = new Permissions();
        ((PermissionCollection)permissions).add(new RuntimePermission("accessClassInPackage.com.sun.deploy.net.proxy.pac"));
        scriptEngineACC = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
    }
}

