# Features
* Ability to set, in the post edit page, an orphan post as source of translated post
* Add support to users with corrupted settings
* Added WPML capabilities (see online documentation)
* Administrators can now edit content that have been already sent to translators
* Categories, tags and taxonomies templates files don't need to be translated anymore (though you can still create a translated file). Taxonomy templates will follow this hierarchy: '{taxonomy}-{lang}-{term_slug}-{lang}.php', '{taxonomy}-{term_slug}-{lang}.php', '{taxonomy}-{lang}-{term_slug}-2.php', '{taxonomy}-{term_slug}-2.php', '{taxonomy}-{lang}.php', '{taxonomy}.php'
* If languages tables are incomplete, it will be possible to restore them
* Improved javascript code style
* Orphan content is now checked when (re)activating the plugin, rather than in each request on back-end side
* When setting a value for "This is a translation of", and the current content already has translations in other languages, each translation gets properly synchronized, as long as there are no conflicts. In case of conflicts, translation won't be synchronized, while the current content will be considered as not linked to an original (in line with the old behavior)

# Fixes
* A lot of data is now cached, further reducing queries
* Admin Strings configured with wpml-config.xml files are properly shown and registered in String Translation
* Browser redirect for 2 letters language codes now works as expected
* Changed "Parsi" to "Farsi" (as it's more commonly used) and fixed some language translations in Portuguese
* Checks if string is already registered before register string for translation. Fixed because it wasn't possible to translate plural and singular taxonomy names in Woocommerce Multilingual
* Compatibility issue with bbPress
* Compatibility with WP-Types repeated fields not being properly copied among translations
* Database dump in troubleshooting page is now available to *admin* and *super admin* users only
* Deleting attachment from post that are duplicated now deleted the duplicated image as well (if "When deleting a post, delete translations as well" is flagged)
* Dramatically reduced the amount of queries ran when checking if content is properly translated in several back-end pages
* Duplicated content retains the proper status
* Empty categories archives does not redirect to the home page anymore
* Fixed a compatibility issue with SlideDeck2 that wasn't retrieving images
* Fixed error when with hierarchical taxonomies and taxonomies with same names of terms
* Fixed issues on moderated and spam comments that exceed 999 items
* Improved security by using *$wpdb->prepare()* wherever is possible
* Is now possible to translate content when displaying "All languages", without facing PHP errors
* Menu and Footer language switcher now follow all settings in WPML->Languages
* Menu synchronization copy custom items if String Translation is not active, or WPML default languages is different than String Translation language
* Menu synchronization now properly fetches translated items
* Post metas are now properly synchronized among duplicated content
* Posts losing they relationship with their translations
* Reactivating WPML after having added content, will properly set the default language to the orphan content
* Reduced number of queries to one per request when retrieving Admin language
* Reduced the number of calls to *$sitepress->get_current_language()*, *$this->get_active_languages()* and *$this->get_default_language()*, to avoid running the same queries more times than needed
* Removed max length issue in translation editor: is now possible to send content of any length
* Removed warnings and unneeded HTML elements when String Translation is not installed/active
* SSL support is now properly handled in WPML->Languages and when setting a domain per language
* Taxonomy Translation doesn't hang anymore on custom hierarchical taxonomies
* Translated static front-page with pagination won't loose the template anymore when clicking on pages
* Updated localized strings
* When deleting the original post, the source language of translated content is set to null or to the first available language