<?php if(!empty($testimonials)): ?>

<div class="testimonials-loop text-center <?php echo esc_attr($el_class); ?>" data-sudo-slider='{"customLink":"#testimonials-nav a", "continuous":true, "effect":"fadeOutIn"}'>
	<ul class="clean-list">
		<?php foreach ($testimonials as $key => $post): ?>
		<li>
			<div class="testimonial-item <?php echo !empty($light) ? 'text-white' : ''; ?>">
				<div class="align-center">
					<?php if(has_post_thumbnail($post->ID)): ?>
						<figure>
							<?php echo balanceTags($testimonials_thumb[$post->ID]); ?>
						</figure>
					<?php endif; ?>
				</div>
				<?php echo !empty($post->post_content) ? sprintf('<p>%s</p>', $post->post_content) : '';  ?>
				<hr class="hr-10 align-center bg-light-grey">

				<?php $testimonial_title = !empty($testimonials_meta[$post->ID]['client_url']) ? 
					sprintf('<a href="%s">%s</a>', $testimonials_meta[$post->ID]['client_url'], $post->post_title) : $post->post_title; ?>

				<?php echo !empty($post->post_title) ? sprintf('<h6 class="uppercase font-alpha no-margin">%s</h6>', $testimonial_title) : '';  ?>

				<?php echo !empty($testimonials_meta[$post->ID]['client_info']) ? 
					sprintf('<small class="uppercase">%s</small>', $testimonials_meta[$post->ID]['client_info']) : ''; ?>
			</div>
		</li>
		<?php endforeach; ?>
	</ul>
</div>

<?php if(count($testimonials) >= 2): ?>

<div id="testimonials-nav" class="slide-navigation align-center">
	<ul class="inline-list">
		<li>
			<a href="#" class="text-<?php echo !empty($light) ? 'white' : 'alpha'; ?>" data-target="prev">
				<i class="icon-110"></i>
			</a>
		</li>
		<li>
			<a href="#" class="text-<?php echo !empty($light) ? 'white' : 'alpha'; ?>" data-target="next">
				<i class="icon-111"></i>
			</a>
		</li>
	</ul>
</div>

<?php endif; ?>

<?php endif; ?>
