<?php if(!empty($portfolio)): ?>

<div class="row">
	<div class="col-md-12">
		<div class="portfolio-filters uppercase clearfix">
			<ul class="inline-list">
				<li>
					<label>
						<input type="radio" name="isotope_filter" value="*" checked>
						<span><?php _e('Everything', 'unik'); ?></span>
					</label>
				</li>
				<?php if(!empty($portfolio_filters)):
						foreach($portfolio_filters as $filter): ?>
					<li>
						<label>
							<input type="radio" name="isotope_filter" value=".<?php echo preg_replace("/[^a-zA-Z0-9-]/", "", strtolower(str_replace(' ', '-', esc_attr($filter)))); ?>">
							<span><?php echo esc_html($filter); ?></span>
						</label>
					</li>
				<?php endforeach; endif; ?>

			</ul>

			<div class="sort-by">
				<input type="checkbox" id="sort-by">
				<label for="sort-by" class="uppercase"><span><?php _e('Sort by', 'unik'); ?> <i class="icon-109 text-alpha"></i></span></label>

				<ul class="clean-list">
					<li>
						<label>
							<input type="radio" name="isotope_sort" value="original-order" checked>
							<span><?php _e('Default', 'unik'); ?></span>
						</label>
					</li>
					<li>
						<label>
							<input type="radio" name="isotope_sort" value="name">
							<span><?php _e('Project name', 'unik'); ?></span>
						</label>
					</li>
					<li>
						<label>
							<input type="radio" name="isotope_sort" value="pubDate">
							<span><?php _e('Publish Date', 'unik'); ?></span>
						</label>
					</li>
					<li>
						<label>
							<input type="radio" name="isotope_sort" value="type">
							<span><?php _e('File type', 'unik'); ?></span>
						</label>
					</li>
				</ul>
			</div>
		</div>
	</div>
</div>

<div class="row <?php echo !empty($fit) ? 'row-fit' : ''; ?>">
	<ul class="clean-list portfolio-loop" data-masonry="li">
		<?php foreach ($portfolio as $key => $post): ?>
		<li class="col-md-<?php echo !empty($column) ? $column : 3; ?> col-sm-4 col-xs-6 <?php echo !empty($portfolio_cat[$post->ID]) ? 
			preg_replace("/[^a-zA-Z0-9-]/", "", strtolower(str_replace(',', ' ', str_replace(' ', '-', implode(',', $portfolio_cat[$post->ID]))))) : ''; ?>" 
			data-portfolio-date="<?php echo !empty($post->post_date) ? strtotime($post->post_date) : ''; ?>" 
			data-portfolio-type="<?php echo !empty($portfolio_cat[$post->ID]) ? 
			strtolower(str_replace(',', ' ', str_replace(' ', '-', implode(',', $portfolio_cat[$post->ID])))) : ''; ?>">

			<div class="portfolio-item text-center">
				<?php if(has_post_thumbnail($post->ID)): ?>
				<figure>
					<?php echo $portfolio_thumb[$post->ID]; ?>
				</figure>
				<?php endif; ?>

				<div class="portfolio-front">
					<div class="bg-alpha">
						<div class="featured-icon align-center">
							<?php if(!empty($portfolio_meta[$post->ID]['lg_img']) || !empty($portfolio_meta[$post->ID]['video_url'])):
									$image = wp_get_attachment_image_src($portfolio_meta[$post->ID]['lg_img'], 'full', true);
									$video_url = $portfolio_meta[$post->ID]['video_url'];
							?>
									
							<figure class="shape-square">
								<a href="<?php echo !empty($video_url) ? $video_url : esc_url($image[0]); ?>" class="bg-white zoom-img" data-strip-group="portfoliounik" data-strip-options="side: 'top'"><i class="icon-367 font-2x"></i></a>
							</figure>
							<?php endif; ?>
						</div>
					</div>
					<div class="text-center uppercase bg-white">
						<?php echo !empty($post->post_title) ? sprintf('<h6 class="no-margin font-alpha"><b>%s</b></h6>', $post->post_title) : '';  ?>
						<?php echo !empty($portfolio_cat[$post->ID]) ? sprintf('<span class="font-beta">%s</span>', $portfolio_cat[$post->ID][0]) : ''; ?>
					</div>
				</div>
			</div>
		</li>
		<?php endforeach; ?>
	</ul>
</div>
<?php endif; ?>
