<?php
	
class TTGeneratePost {

	public $tt_posts = array();
	public $tt_taxonomy = array();

	public function __construct() {
		add_action( 'init', array($this, 'tt_generate_post'), 0 );
		add_action( 'init', array($this, 'tt_generate_taxonomy'), 0 );
	}

	public function tt_create_post( $name, $settings = array()) {
		$this->tt_posts[$name] = $settings;
	}

	public function tt_create_taxonomy( $name, $post, $settings = array() ) {
		$this->tt_taxonomy[$name] = array_merge($settings, array('tax_post' => $post));
	}

	public function tt_generate_post() {
		if(!empty($this->tt_posts)) {
			foreach ($this->tt_posts as $name => $settings) {
				register_post_type( $name, $this->tt_post_args( $name, $settings ) );
			}
		}
	}

	public function tt_generate_taxonomy() {
		if(!empty($this->tt_taxonomy)) {
			foreach ($this->tt_taxonomy as $name => $settings) {
				register_taxonomy( $name . '_tax', $settings['tax_post'], $this->tt_taxonomy_args( $name, $settings ) );
			}
		}
	}

	public function tt_post_label( $name ) {

		$name = ucfirst($name);

		return array(
			'name'                => _x( $name , 'Post Type General Name', 'tt' ),
			'singular_name'       => _x( $name , 'Post Type Singular Name', 'tt' ),
			'menu_name'           => __( $name, 'tt' ),
			'name_admin_bar'      => __( $name, 'tt' ),
			'parent_item_colon'   => __( 'Parent Item:', 'tt' ),
			'all_items'           => __( 'All Items', 'tt' ),
			'add_new_item'        => __( 'Add New Item', 'tt' ),
			'add_new'             => __( 'Add New', 'tt' ),
			'new_item'            => __( 'New Item', 'tt' ),
			'edit_item'           => __( 'Edit Item', 'tt' ),
			'update_item'         => __( 'Update Item', 'tt' ),
			'view_item'           => __( 'View Item', 'tt' ),
			'search_items'        => __( 'Search Item', 'tt' ),
			'not_found'           => __( 'Not found', 'tt' ),
			'not_found_in_trash'  => __( 'Not found in Trash', 'tt' ),
		);
	}

	public function tt_post_args( $name, $settings ) {
		$args = array(
			'label'               => __( $name, 'tt' ),
			'description'         => __( 'Post Type Description', 'tt' ),
			'labels'              => $this->tt_post_label($name),
			'supports'            => array( ),
			'taxonomies'          => array_keys($this->tt_taxonomy),
			'hierarchical'        => false,
			'public'              => true,
			'show_ui'             => true,
			'show_in_menu'        => true,
			'menu_position'       => 100,
			'show_in_admin_bar'   => true,
			'show_in_nav_menus'   => true,
			'can_export'          => true,
			'has_archive'         => true,
			'exclude_from_search' => false,
			'publicly_queryable'  => true,
			'capability_type'     => 'page',
		);

		return wp_parse_args( $settings, $args );
	}

	public function tt_taxonomy_args( $name, $settings ) {

		$nice_name = ucfirst($name);

		$labels = array(
			'name'                       => _x( $nice_name, 'taxonomy general name', 'tt' ),
			'singular_name'              => _x( $nice_name, 'taxonomy singular name', 'tt' ),
			'search_items'               => __( 'Search ' . $nice_name, 'tt' ),
			'popular_items'              => __( 'Popular ' . $nice_name, 'tt' ),
			'all_items'                  => __( 'All' . $nice_name, 'tt' ),
			'parent_item'                => null,
			'parent_item_colon'          => null,
			'edit_item'                  => __( 'Edit' . $nice_name, 'tt' ),
			'update_item'                => __( 'Update' . $nice_name, 'tt' ),
			'add_new_item'               => __( 'Add New '. $nice_name, 'tt' ),
			'new_item_name'              => __( 'New Writer' . $nice_name, 'tt' ),
			'separate_items_with_commas' => __( 'Separate '. $nice_name .' with commas', 'tt' ),
			'add_or_remove_items'        => __( 'Add or remove ' . $nice_name, 'tt' ),
			'choose_from_most_used'      => __( 'Choose from the most used '. $nice_name, 'tt' ),
			'not_found'                  => __( 'No '. $nice_name .' found.', 'tt' ),
			'menu_name'                  => __( $nice_name, 'tt' ),
		);

		$args = array(
			'hierarchical'          => true,
			'labels'                => $labels,
			'show_ui'               => true,
			'show_admin_column'     => true,
			'query_var'             => true,
			'rewrite'               => array( 'slug' => $name )
		);

		return wp_parse_args( $settings, $args );
	}

	public function tt_add_post( $post, $taxonomy = false ) {

		if(!empty($post)) {
			$this->tt_create_post( key($post), reset($post) );
		}

		if(!empty($taxonomy)) {
			$this->tt_create_taxonomy( key($taxonomy), key($post), reset($taxonomy));
		}
	}
}