// FOR THE FUTURE ME - HOW THE SYSTEM WORKS
// ------------------
// 1) link requests are sent with javascript function getContent or setFilter
// 2) javascript functions getContent or setFilter are AJAX requests that invokes contentDecider.php, to which ordinary GET operators are passed
// 3) contentDecider.php includes different page, depending on the GET operator that it receives
// 4) contentDecider.php may include a different page and pass other GET operators to page (eg blogFront.php). These pages then again decide on the content to include depending on the GET operator that they receive
// 5) contentDecider.php (or other pages included) returns HTML output to javascript functions getContent or setFilter, which updates the span element contentContainer on index.php

// UPDATE SEPT 2016
// php include function no longer supports relative url with a parameter attached to the calling page
// i.e. OK for calling to include blogEntry.php, not OK for blogEntry.php?id=0000000, to get around this
// 1) filters are saved to variables such as dispMonth, dispYear, dispDay, dispCategory, dispTag
//    (dispId, dispKeyword (for searches), dispAnchor (for use in the search page) are saved at contentDecider.php, everything else saved at blogFront.php)
// 2) the child page is called
// 3) the child page fetches the variable by directing addressing the variable, instead of attaching the varaible as a url parameter and for the child page to call it using $_GET

// ON PAGE LOAD
// ------------------
// javascript function onPageLoad is invoked when the page loads, which parses the hash and triggers the getContent function

// BACK/FORWARD BUTTON
// ------------------
// whenever user clicks a link that involves loading a "new page" i.e. setfilter, getContent, history.pushState is invoked to leave a history in the browser
// onpopstate is invoked whenever users click the back/forward button. this changes the hash in the URL, and the event handler (window.onpopstate) is called to change the page according to the URL (using onPageLoad)
// when this happens, the history.pushState function is called again and thereby overwriting the history in the "forward button". That's why the leaveHistory parameter is included to bypass calling history.pushState (and thereby avoid overwriting history for the "forward" button)

// IMPORTING ENTRIES
// -------------------
// make sure line breaks are marked with <br>

// link format: javascript:getContent(type,id); (or simply call the writeGetContentLink function)

waitScreen = "<table style='width: 100%; border-collapse: collapse;'><tr><td><p>&nbsp;</p><p>&nbsp;</p><p>&nbsp;</p><p align=center><img width=15px src=waiting-cursor.gif>Loading ...</p></td></tr></table>";
waitScreenNoTable = "<p align=center><img width=15px src=http://www.chezjeff.net/blog/waiting-cursor.gif>Loading ...</p>";

function onPageLoad(hash, leaveHistory) {
    switch(window.location.hash.substring(1, 5)) {
    case "blog":
        getContent("blog", hash.substring(6), leaveHistory);
        break;
    case "bfil":
        var filterArray = window.location.hash.substring(6).split(";");
        setFilter(filterArray[0], filterArray[1], filterArray[2], filterArray[3], filterArray[4], "", leaveHistory);
        break;
    case "abou":
        getContent("abou", "", leaveHistory);
        break;
    case "cont":
        getContent("cont", "", leaveHistory);
        break;
    case "arch":
        getContent("arch", "", leaveHistory);
        break;
    case "sear":
        var keyword = window.location.hash.substring(6,window.location.hash.indexOf(";"));
        var anchor = window.location.hash.substring(window.location.hash.indexOf(";")+1, window.location.hash.length);
        exeSearch(keyword, anchor);
        break;
    case "":
        getContent("blog", "", leaveHistory);
        break;
    };
    reloadBg();
};

function getContent(type, id, leaveHistory) {
    if (((type == "blog") && (id != undefined)) || (type != "blog")) {
        if (leaveHistory != true)
            history.pushState(null, null, "#" + type + "-" + id);
    };
    document.getElementById("year").value = "";
    document.getElementById("month").value = "";
    document.getElementById("day").value = "";
    document.getElementById("category").value = "";
    document.getElementById("tag").value = "";
    var xmlhttp = new XMLHttpRequest();
    xmlhttp.onreadystatechange = function() {
        if (xmlhttp.readyState == 1) {// retrieving data
            document.getElementById("contentContainer").innerHTML = waitScreen;
        }
        if (xmlhttp.readyState == 4 && xmlhttp.status == 200) {
            document.getElementById("contentContainer").innerHTML = xmlhttp.responseText;
        };
    };
    xmlhttp.open("GET", "contentDecider.php?page=" + type + "&id=" + id);
    xmlhttp.send();
};

function shiftPost(type, id, leaveHistory) {
    if (((type == "blog") && (id != undefined)) || (type != "blog")) {
        if (leaveHistory != true)
            history.pushState(null, null, "#" + type + "-" + id);
    };
    var xmlhttp = new XMLHttpRequest();
    xmlhttp.onreadystatechange = function() {
        if (xmlhttp.readyState == 1) {// retrieving data
            document.getElementById("entry").innerHTML = waitScreen;
            document.getElementById("entryInfo").innerHTML = waitScreenNoTable;
        }
        if (xmlhttp.readyState == 4 && xmlhttp.status == 200) {
            document.getElementById("entry").innerHTML = xmlhttp.responseText;
            xmlhttp.onreadystatechange = function() {
                if (xmlhttp.readyState == 4 && xmlhttp.status == 200)
                    document.getElementById("entryInfo").innerHTML = xmlhttp.responseText;
            };
            xmlhttp.open("GET", "blog-shiftPostInfo.php?id=" + id);
            xmlhttp.send();
        };
    };
    xmlhttp.open("GET", "blog-shiftPost.php?id=" + id);
    xmlhttp.send();
};

function showList(tag) {
    var xmlhttp = new XMLHttpRequest();
    xmlhttp.onreadystatechange = function() {
        if (xmlhttp.readyState == 1) {// retrieving data
            document.getElementById("otherPostList").innerHTML = waitScreenNoTable;
        }
        if (xmlhttp.readyState == 4 && xmlhttp.status == 200) {
            document.getElementById("otherPostList").innerHTML = xmlhttp.responseText;
            xmlhttp.onreadystatechange = function() {
                if (xmlhttp.readyState == 4 && xmlhttp.status == 200)
                    document.getElementById("otherPostList").innerHTML = xmlhttp.responseText;
            };
            xmlhttp.open("GET", "blog-showList.php?tag=" + tag);
            xmlhttp.send();
        };
    };
    xmlhttp.open("GET", "blog-showList.php?tag=" + tag);
    xmlhttp.send();
};

function setFilter(year, month, day, category, tag, anchor, leaveHistory) {
    if (year != "")
        document.getElementById("year").value = year;
    if (month != "")
        document.getElementById("month").value = month;
    if (day != "")
        document.getElementById("day").value = day;
    if (category != "") {
        category = category.replaceAll(" ", "-");
        document.getElementById("category").value = category;
    };
    if (tag != "") {
        tag = tag.replaceAll(" ", "-");
        if (document.getElementById("tag").value.indexOf(tag) == -1)
            document.getElementById("tag").value = document.getElementById("tag").value + "," + tag;
    }
    if (anchor != "")
        document.getElementById("anchor").value = anchor;
    if (leaveHistory != true)
        // only condition where pushState is set to false is when onpopstate is invoked (i.e. when users click back/forward button)
        // in such a case the following line must be skipped to avoid overwriting the history for the 'forward' button
        history.pushState(null, null, "#bfil-" + document.getElementById("year").value + ";" + document.getElementById("month").value + ";" + document.getElementById("day").value + ";" + document.getElementById("category").value + ";" + document.getElementById("tag").value + ";" + document.getElementById("anchor").value);
    exeFilter();
};

function removeFilter(year, month, day, category, tag, anchor) {
    if (year == true)
        document.getElementById("year").value = "";
    if (month == true)
        document.getElementById("month").value = "";
    if (day == true)
        document.getElementById("day").value = "";
    if (category == true)
        document.getElementById("category").value = "";
    if (tag != "") {
        document.getElementById("tag").value = document.getElementById("tag").value.replace("," + tag.replaceAll(" ", "-"), "");
    };
    if (anchor == true)
        document.getElementById("anchor").value = "";
    history.pushState(null, null, "#bfil-" + document.getElementById("year").value + ";" + document.getElementById("month").value + ";" + document.getElementById("day").value + ";" + document.getElementById("category").value + ";" + document.getElementById("tag").value + ";" + document.getElementById("anchor").value);
    exeFilter();
};

function exeFilter() {
    var xmlhttp = new XMLHttpRequest();
    xmlhttp.onreadystatechange = function() {
        if (xmlhttp.readyState == 1) {// retrieving data
            document.getElementById("contentContainer").innerHTML = waitScreen;
        };
        if (xmlhttp.readyState == 4 && xmlhttp.status == 200) {
            document.getElementById("contentContainer").innerHTML = xmlhttp.responseText;
        };
    };
    xmlhttp.open("GET", "contentDecider.php?page=bfil&year=" + document.getElementById("year").value + "&month=" + document.getElementById("month").value + "&day=" + document.getElementById("day").value + "&category=" + document.getElementById("category").value + "&tag=" + document.getElementById("tag").value + "&anchor=" + document.getElementById("anchor").value);
    xmlhttp.send();
};

function exeSearch(keyword, anchor) {
    history.pushState(null, null, "#sear-" + keyword + ";" + anchor);
    var xmlhttp = new XMLHttpRequest();
    xmlhttp.onreadystatechange = function() {
        if (xmlhttp.readyState == 1) {// retrieving data
            document.getElementById("contentContainer").innerHTML = waitScreen;
        };
        if (xmlhttp.readyState == 4 && xmlhttp.status == 200) {
            document.getElementById("contentContainer").innerHTML = xmlhttp.responseText;
        };
    };
    xmlhttp.open("GET", "contentDecider.php?page=sear&keyword=" + keyword + "&anchor=" + anchor);
    xmlhttp.send();
};

function saveComments() {
    if (validateComment() == true) {
        var name = document.getElementById("name").value;
        var link = document.getElementById("link").value;
        var comment = document.getElementById("commentBody").value;
        var id = document.getElementById("id").value;
        $.ajax({
            type : "POST",
            url : "blog-saveComment.php?id=" + id,
            data : {
                name : name,
                link : link,
                comment : comment,
                id : id,
            },
            success : function() {
                var xmlhttp = new XMLHttpRequest();
                xmlhttp.onreadystatechange = function() {
                    if (xmlhttp.readyState == 1) {// retrieving data
                        document.getElementById("comment").innerHTML = waitScreen;
                    };
                    if (xmlhttp.readyState == 4 && xmlhttp.status == 200) {
                        var commentForm;
                        commentForm = xmlhttp.responseText;
                        xmlhttp.onreadystatechange = function() {
                            if (xmlhttp.readyState == 4 && xmlhttp.status == 200) {
                                document.getElementById("comment").innerHTML = xmlhttp.responseText;
                            };
                        };
                        xmlhttp.open("GET", "blog-loadComment.php?id=" + id, false);
                        xmlhttp.send();
                    };
                    document.getElementById("comment").innerHTML += '<p class="notification"><b>Your comment has been saved.</b></p>';
                    document.getElementById("comment").innerHTML += commentForm;
                };
                xmlhttp.open("GET", "blog-commentForm.php?&id=" + id);
                xmlhttp.send();
            },
        });
    };
};

function switchCalendar(target) {
    setFilter(target.substring(0, 4), target.substring(4), "", "", "", "0");
};

function switchPage(anchor) {
    setFilter("", "", "", "", "", anchor);
};

function reloadBg() {
    var selector;
    selector = parseInt(Math.random() * 10);
    switch (selector) {
    case 0:
    case 5:
        document.body.style.backgroundPosition = "right bottom";
        document.body.style.backgroundImage = "url('bg-img/biobg.png')";
        break;
    case 1:
    case 6:
        document.body.style.backgroundPosition = "right top";
        document.body.style.backgroundImage = "url('bg-img/photoBg.png')";
        break;
    case 2:
    case 7:
        document.body.style.backgroundPosition = "right bottom";
        document.body.style.backgroundImage = "url('bg-img/mur.png')";
        break;
    case 3:
    case 8:
        document.body.style.backgroundPosition = "right bottom";
        document.body.style.backgroundImage = "url('bg-img/sitting-writer.png')";
        break;
    case 4:
    case 9:
        document.body.style.backgroundPosition = "right bottom";
        document.body.style.backgroundImage = "url('bg-img/trois-drapeau.png')";
        break;
    };
};

function validateComment() {
    if (document.getElementById("name").value == "") {
        alert("You must fill in your name before you can post a comment.");
        return false;
    } else if (document.getElementById("commentBody").value == "") {
        alert("You must insert your comments to be posted.");
        return false;
    } else if (document.getElementById("verif").value == "") {
        alert("You must fill in the verification code.");
        return false;
    } else if (validateSecPic() == false) {
        alert("Verification code is incorrect.");
        return false;
    } else
        return true;
};

function validateSecPic() {
    var verif = document.getElementById("verif").value;
    switch (document.getElementById("modelVerif").value) {
    case "1":
        if (verif == "gu6p7")
            return true;
        else
            return false;
        break;
    case "2":
        if (verif == "my3jz")
            return true;
        else
            return false;
        break;
    case "3":
        if (verif == "iade5")
            return true;
        else
            return false;
        break;
    case "4":
        if (verif == "sh4fk")
            return true;
        else
            return false;
        break;
    case "5":
        if (verif == "rn83s")
            return true;
        else
            return false;
        break;
    };
};

String.prototype.replaceAll = function(search, replace) {
    //if replace is not sent, return original string otherwise it will
    //replace search string with 'undefined'.
    if (replace === undefined) {
        return this.toString();
    }

    return this.replace(new RegExp('[' + search + ']', 'g'), replace);
};

function showParagraph(id) {
    // this function 1) hides the portion of the paragraph as designated by the user 2) the "show more" link
    // used by entry.php, index.php
    document.getElementById('show' + id).style.display = "none";
    document.getElementById(id).style.display = "inline";
};

function hideParagraph(id) {
    // this function undoes showParagraph
    document.getElementById('show' + id).style.display = "inline";
    document.getElementById(id).style.display = "none";
};

window.onpopstate = function(event) {
    // onpopstate catches when the user clicks the 'back' button on the browser
    // see https://developer.mozilla.org/en-US/docs/Web/API/WindowEventHandlers/onpopstate
    onPageLoad(window.location.hash, true);
};

function showDefaultText() {
    if (document.getElementById("searchBox").value == "") {
        document.getElementById("searchBox").value = "Keyword here";
        document.getElementById("searchBox").style.color = "grey";
    };
};
function hideDefaultText() {
    if (document.getElementById("searchBox").value == "Keyword here") {
        document.getElementById("searchBox").value = "";
        document.getElementById("searchBox").style.color = "black";
    };
};
                    
                    
                    
                    